/* 
Statistik 8a (Kindeswohlgefhrdungseinschtzung) ab Berichtsjahr 2023
*/

select   v.bereich as "Bereich Nr.",
         v.aktenzeichen as "Aktenzeichen",
         nvl(u2.name,'') as "Sachbearbeiter",
         a.nachname as "Nachname JM",
         a.vorname as "Vorname JM",
         to_char(p.geburtsdatum,'dd.mm.yyyy') as "GebDat JM",
         
         to_char(m.vondatum,'dd.mm.yyyy') as "Meldungseingang",
         to_char(m.bisdatum,'dd.mm.yyyy') as "Abschluss Einschtzung",
         
-- Status und Grunddaten der Statistikaktion
         
         case s.freigegeben         when '1' then 'ja' else 'nein' end as "Freigabe",
         case s.uebergabeerfolgt    when '0' then 'nein' else 'ja' end as "bergabe",
         case s.geloescht           when 0 then 'nein' else 'ja' end as "nach berg. gelscht",
         
         s.ef2 as "Lfd. Nr. nach berg",
         s.ef3 as "Kennnummer nach berg",
         
-- Abschnitt A - Allgemeine Angaben zum Minderjhrigen
         
         case s.ef4 
         when '1' then 'mnnlich' 
         when '2' then 'weiblich'
         when '3' then 'divers'
         when '7' then 'ohne Angabe (nach Geburtenregister)' 
         else '(Angabe fehlt)' end as "Geschlecht",
               
         s.ef5u1 as "Geburtsmonat",
         s.ef5u2 as "Geburtsjahr",
         
         case s.a3wdhmeldung 
                  when '1' then 'X'
                           else ''
         end as "Wiederholte Meldung",

         case a4ehkoerpbeh 
                  when '1' then 'X'
                           else ''
         end as "EGH krperl. Behind",

         case a4ehgeistbeh 
                  when '1' then 'X'
                           else ''
         end as "EGH geist. Behind",

         case a4ehseelbeh 
                  when '1' then 'X'
                           else ''
         end as "EGH seel. Behind",

         case a4ehkeinebeh 
                  when '1' then 'X'
                           else ''
         end as "keine EGH",
              
-- Abschnitt B - Angaben zu den Eltern
         
         case s.ef7 when '1' then 'unter 18 Jahre'
                    when '2' then '18 bis unter 27 Jahren'
                    when '3' then '27 Jahre oder lter'
                    when '4' then 'unbekannt'
                    when '5' then 'verstorben'
                    else '(Angabe fehlt)'
         end as "Alter des Vaters",
         
         case s.ef8 when '1' then 'unter 18 Jahre'
                    when '2' then '18 bis unter 27 Jahren'
                    when '3' then '27 Jahre oder lter'
                    when '4' then 'unbekannt'
                    when '5' then 'verstorben'
                    else '(Angabe fehlt)'
         end as "Alter der Mutter",

         case b2mighinterg when '1' then 'X'
                           else ''
         end as "Ausl Herkunft Elternteil",

         case b3sprache when '1' then 'deutsch'
                        when '2' then 'nicht deutsch'
                        else '(Angabe fehlt)'
         end as "Sprache Familie",
         
-- Abschnitt C - Gewhnlicher Aufenthaltsort des Minderjhrigen
         
         case s.ef9 when '01' then 'bei den Eltern'
                    when '02' then 'bei einem alleinerziehendem Elternteil'
                    when '03' then 'bei einem Elternteil mit Partner/in'
                    when '04' then 'bei Verwandten'
                    when '05' then 'bei einer sonstigen Person'
                    when '06' then 'in einer Pflegefamilie ( 33, 35a SGB VIII)'
                    when '07' then 'in einem Heim/einer sonstigen betreuten Wohnform ( 35, 35a SGB VIII)'
                    when '08' then 'in einer eigenen Wohnung/Wohngemeinschaft'
                    when '09' then 'ohne feste Unterkunft'
                    when '10' then 'unbekannt/keine Angabe mglich'
                    when '11' then 'in einer Aufnahmeeinrichtung/Gemeinschaftsunterkunft ( 44, 53 AsylG)'
                    when '12' then 'in einer anderen Einrichtung'
                    else '(Angabe fehlt)'
         end as "Aufenthaltsort",
         
-- Abschnitt D - Meldende Institution / Person
         
         case s.ef10 when '01' then 'Jugendamt/Sozialer Dienst'
                     when '02' then 'Beratungsstelle'
                     when '03' then 'Andere Einrichtung/anderer Dienst der Kinder- und Jugendhilfe'
                     when '04' then 'Einrichtung der Kinder- und Jugendarbeit'
                     when '05' then 'Kindertageseinrichtung/Kindertagespflegeperson'
                     when '06' then 'Schule'
                     when '07' then 'Gesundheitspersonal/Gesundheitswesen'
                     when '08' then 'Polizei/Gericht/Staatsanwaltschaft'
                     when '09' then 'Eltern(-teil), Personensorgeberechtigte/-r'
                     when '10' then 'Minderjhrige/-r selbst'
                     when '11' then 'Verwandte'
                     when '12' then 'Bekannte/Nachbarn'
                     when '13' then 'Anonyme Meldung'
                     when '14' then 'Sonstige'                     
                     else '(Angabe fehlt)'
         end as "Meldende Inst./Person",
         
-- Abschnitt E - Inanspruchnahme der KJH zum Zeitpunkt der Gefhrdungseinschtzung
         
         case s.ef11 when '1' then 'X' else '' end as "Unterst.  16-18",
         case s.ef12 when '1' then 'X' else '' end as "Gem.Wohnf.  19",
         case s.ef13 when '1' then 'X' else '' end as "Amb./teilstat.  27-32,35",
         case s.ef14 when '1' then 'X' else '' end as "Fam.ers. HzE  27,33-35",
         case s.ef15 when '1' then 'X' else '' end as "Eingl.hilfe  35a",
         case s.ef16 when '1' then 'X' else '' end as "Vorl. Schutzm.  42",
         case s.ef17 when '1' then 'X' else '' end as "Keine Leistg.",
         
-- Abschnitt F - Ergebnis der Gefhrdungseinschtzung
         
         case s.ef18 when '1' then 'Kiwo-Gefhrdung'
                     when '2' then 'Latente Kiwo-Gefhrdung'
                     when '3' then 'keine Kiwo-Gefhrdung, aber Hilfebedarf'
                     when '4' then 'keine Kiwo-Gefhrdung, kein Hilfebedarf'
                     else '(Angabe fehlt)'
         end as "Ergebnis Einschtzung",
         
         (case when s.ef18 in ('1','2') then case s.ef19 when '1' then 'X' else '' end else '' end) as "Vernachlssigung",
         (case when s.ef18 in ('1','2') then case s.ef20 when '1' then 'X' else '' end else '' end) as "krperl. Misshandlung",
         (case when s.ef18 in ('1','2') then case s.ef21 when '1' then 'X' else '' end else '' end) as "psychische Misshandlung", 
         (case when s.ef18 in ('1','2') then case s.ef22 when '1' then 'X' else '' end else '' end) as "sexuelle Gewalt",
         
         case s.f31gefmutter when '1' then 'X'
                             else '' 
         end as "Gef. Mutter/Adoptivmutter",

         case s.f31gefvater when '1' then 'X'
                             else '' 
         end as "Gef. Vater/Adoptivvater",

         case s.f31gefpfmutter when '1' then 'X'
                             else '' 
         end as "Gef. Pflegemutter",

         case s.f31gefpfvater when '1' then 'X'
                             else '' 
         end as "Gef. Pflegevater",

         case s.f31gefstmutter when '1' then 'X'
                             else '' 
         end as "Gef. Stiefmutter",

         case s.f31gefstvater when '1' then 'X'
                             else '' 
         end as "Gef. Stiefvater",

         case s.f31gefsonstver when '1' then 'X'
                             else '' 
         end as "Gef. sonst. Verw.",

         case s.f31gefandere when '1' then 'X'
                             else '' 
         end as "Gef. andere Pers",

         case s.f31gefkeineang when '1' then 'X'
                             else '' 
         end as "Gef. keine Angabe mgl",

         case s.f32gefhauptpers when '01' then 'Mutter (auch Adoptivmutter)'
                                when '02' then 'Vater (auch Adoptivvater)'
                                when '03' then 'Pflegemutter'
                                when '04' then 'Pflegevater'
                                when '05' then 'Stiefmutter, neue Partnerin eines Elternteils'
                                when '06' then 'Stiefvater, neuer Partner eines Elternteils'
                                when '07' then 'Sonstige Verwandte'
                                when '08' then 'Andere Person/en'
                                when '09' then 'Keine Angabe mglich'
                                else '' 
         end as "Gef. Hauptperson",

                  (case when s.ef18 in ('1','2','3') then case s.ef31 when '1' then 'X' else '' end else '' end) as "Fortf bisherige Hilfe",

         (case when s.ef18 in ('1','2','3') then case s.ef23 when '1' then 'X' else '' end else '' end) as "Neu:  16-18",
         (case when s.ef18 in ('1','2','3') then case s.ef24 when '1' then 'X' else '' end else '' end) as "Neu:  19",
         (case when s.ef18 in ('1','2','3') then case s.ef25 when '1' then 'X' else '' end else '' end) as "Neu:  28",         
         (case when s.ef18 in ('1','2','3') then case s.ef26 when '1' then 'X' else '' end else '' end) as "Neu: amb/teilst  27,29-32,35",
         (case when s.ef18 in ('1','2','3') then case s.ef27 when '1' then 'X' else '' end else '' end) as "Neu: fam.ers. HzE  27,33-35",
         (case when s.ef18 in ('1','2','3') then case s.ef28 when '1' then 'X' else '' end else '' end) as "Neu: Eingl.hilfe  35a",
         (case when s.ef18 in ('1','2','3') then case s.ef29 when '1' then 'X' else '' end else '' end) as "Neu: Vorl. Schutzm.  42",
         (case when s.ef18 in ('1','2','3') then case s.ef30 when '1' then 'X' else '' end else '' end) as "Neu: Kinder- u. Jugendpsych.",
         (case when s.ef18 in ('1','2','3') then case s.ef31a when '1' then 'X' else '' end else '' end) as "Neu: andere Hilfe",
         (case when s.ef18 in ('1','2','3') then case s.ef31b when '1' then 'X' else '' end else '' end) as "Keine neue Hilfe",
              
         (case when s.ef18 in ('1','2','3') then case s.ef32 when '1' then 'ja' when '2' then 'nein' else '(Angabe fehlt)' end 
               else 'entfllt' end) as "Anrufung Familiengericht",

         s.ef6u1 as "Monat Abschl GefEinsch.",
         s.ef6u2 as "Jahr Abschl GefEinsch."

from     n_vorgang v left join n_benutzer u2          on v.sachbearbeiter = u2.lfdnr
                     inner join n_vorgbeteiligte b    on v.vorgangsnummer = b.vorgang 
                                                      and b.beteiligtenart = 7
                     inner join n_adressen a          on b.adresse = a.adressnummer
                     inner join n_personendaten p     on b.adresse = p.zuordnungsnummer
                     inner join n_vorgmassnahme h     on v.vorgangsnummer = h.vorgang
                     inner join n_massnahme m         on h.massnahme = m.massnahmennummer
                     inner join n_stat8a s            on h.massnahme = s.massnahmennummer
                     left join n_benutzer u           on s.user_fk = u.lfdnr

where  to_number(to_char(m.bisdatum,'yyyy')) >= 2023

order by v.bereich,
         a.nachname,
         a.vorname